@extends('layouts.admin')
@section('content')
<style>


    form#vendorFilterForm span#select2-vendorSelect-container {
        padding: 10px;
    }
    
    
    
    form#vendorFilterForm span.select2-selection {
        height: 50px;
        min-width: 230px;
        display: flex;
        align-items: center;
        font-size: 14px;
    }
    
    form#vendorFilterForm span.select2-selection__arrow {
        top: 14px;
    }
    
    form#vendorFilterForm .select2-results__option {
        padding: 10px 12px !important;
        font-size: 16px !important;
    }
    
    
    .select2-results__options li {
        padding: 8px;
        font-size: 14px;
    }
    </style>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>booking analytics</h2>
            <form method="GET" action="{{ route('admin.booking.index') }}" id="timeFilterForm">
                <select name="time_filter" class="form-select select-main-head" aria-label="Default select example">
                    <option value="year" {{ request('time_filter', 'year') == 'year' ? 'selected' : '' }}>Year</option>
                    <option value="month" {{ request('time_filter') == 'month' ? 'selected' : '' }}>Month</option>
                    <option value="week" {{ request('time_filter') == 'week' ? 'selected' : '' }}>Week</option>
                    <option value="day" {{ request('time_filter') == 'day' ? 'selected' : '' }}>Day</option>
                </select>
            </form>
        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Net Revenue(excl. tax)</p>
                                    <h4>{{ $analytics['net_revenue'] }}€</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Number of Bookings</p>
                                    <h4>{{ $analytics['total_bookings'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Number Of Cancellations</p>
                                    <h4>{{ $analytics['cancellations'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/lost.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Revenue Bookings</p>
                                    <h4>{{ $analytics['total_revenue'] }}€</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/parot-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       
        <div class="sownload-cv-pdf">
            <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
            <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
        </div>
        <form id="exportForm" method="GET" action="" style="display: none;">
            <input type="hidden" name="time_filter" id="exportTimeFilter" value="{{ request('time_filter', 'year') }}">
            <input type="hidden" name="status" id="exportStatusFilter" value="{{ request('status', 'all') }}">
            <input type="hidden" name="vendor_id" id="exportVendorFilter" value="{{ request('vendor_id') }}">

        </form>
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <div class="cont-wrap">
                    <h6>Booking Management</h6>
                    <p style="margin-top: 6px ; font-size: 14px"><strong>Red Flag :</strong> Delay/Damaged Cases</p>
                    <p style=" font-size: 14px"><strong>Grey Flag :</strong>SPO related bookings</p>
                    <p style=" font-size: 14px"><strong>Blue Flag :</strong>Prefered Timing Requests - here you will get the full slot range information in the notification.</p>
            </div>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search Name/Email"
                                type="text" id="booking_user" class="form-control" value="{{ request('search') }}">
                        </div>
                    </div>
                    @php
                        $status = request()->get('status', ''); // get status from query
                        $statusLabel = 'Filter'; // default text
                        if ($status && $status !== 'all') {
                            $statusLabel = ucfirst($status); // make first letter capital
                        } elseif ($status === 'all') {
                            $statusLabel = 'All Statuses';
                        }
                    @endphp
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="statusFilterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> {{$statusLabel}}
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'all']) }}">All Statuses</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'pending']) }}">Pending</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'confirmed']) }}">Confirmed</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'completed']) }}">Completed</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'cancelled']) }}">Cancelled</a></li>
                            </ul>
                        </div>
                    </div>
                    @php
                        $selectedVendorId = request('vendor_id');
                        $selectedVendorLabel = 'Esperantostr. 10, 70197 Stuttgart';
                        if ($selectedVendorId && $vendors->where('id', $selectedVendorId)->first()) {
                            $v = $vendors->where('id', $selectedVendorId)->first();
                            $selectedVendorLabel = "{$v->street} {$v->zip_code} {$v->city} ({$v->id})";
                        }
                    @endphp

                    <div class="filter-main-div">
                        <p class="lable-filt">Vendor:</p>
                        <form id="vendorFilterForm">
                            <select id="vendorSelect" class="form-control" name="vendor_id" style="width: 250px;" data-placeholder="Select Vendor">
                                <option value="" {{ request('vendor_id') == null ? 'selected' : '' }}>
                                    Esperantostr. 10, 70197 Stuttgart
                                </option>
                                @foreach($vendors as $vendor)
                                    <option value="{{ $vendor->id }}"
                                        {{ request('vendor_id') == $vendor->id ? 'selected' : '' }}>
                                        {{ $vendor->street }} {{ $vendor->zip_code }} {{ $vendor->city }} (SPOID{{ $vendor->id }})
                                    </option>
                                @endforeach
                            </select>
                        </form>
                    </div>

                    <a class="add-notification-btn" href="{{route('admin.getquote')}}">Add Booking</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Booking ID</th>
                            <th>Customer Name</th>
                            <th>Email Address</th>
                            <th>Rental Period</th>
                            <th>Total Amount</th>
                            <th>Rental Days</th>
                            <th>Additional Rental Days </th>
                            <th>New DropOff Date/Time </th>
                            <th>Damaged</th>
                            <th>Delayed Fee + Additional Rental</th>
                            <th>Extra Cost Paid</th>
                            <th>status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="searchBookingUser">
                        @foreach($bookings as $booking)
                        <tr>
                            <td>
                                @if($booking->items->contains(function ($item) {
                                    return !empty($item->vendor_id);
                                }))
                                    <span class="text-secondary me-1" title="Includes vendor items">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif
                                #{{ $booking->id }}
                               
                                @if($booking->items->contains('user_timing', 1))
                                    <span class="text-primary me-1" title="Customer requested timing change">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif

                                {{-- Red flag for delay or damaged item --}}
                                @if($booking->delay || $booking->items->contains('damage', 1))
                                    <span class="text-danger me-1" title="Delay or Damage reported">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif
                            </td>
                            
                            <td>
                                @if($booking->userDetails)
                                    {{ $booking->userDetails->first_name }} {{ $booking->userDetails->last_name }}
                                @else
                                    N/A
                                @endif
                            </td>
                            
                            <td>
                                @if($booking->userDetails)
                                    {{ $booking->userDetails->email }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->items->isNotEmpty())
                                    {{ $booking->items->first()->pickup_date->format('d.m.Y') }} - 
                                    {{ $booking->items->first()->dropoff_date->format('d.m.Y') }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>{{number_format($booking->total , 2 , ',' , '.')}} €</td>

                            <td>
                                @if($booking->items->isNotEmpty())
                                    {{ $booking->items->first()->days }} Days
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->additional_days)
                                    {{$booking->additional_days }} Days
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->new_dropoff_date)
                                    {{ \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y') }} -  {{ \Carbon\Carbon::parse($booking->items->first()->new_dropoff_time)->format('H:i') }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->items->contains('damage', 1))
                                    
                                        <span>Yes</span>
                                    
                                @endif
                            </td>

                            <td>{{ number_format($booking->additional_days_rent + $booking->delay_fees , 2 , ',' , '.') }} €</td>
                            <td>
                                <p>
                                    @if(($booking->additional_days_rent + $booking->delay_fees) == 0)
                                        N/A
                                    @elseif(isset($booking->delay_fees_paid))
                                        {{ $booking->delay_fees_paid ? 'Paid' : 'Pending' }}
                                    @else
                                        N/A
                                    @endif
                                </p>
                            </td>
                            <td>
                                <select class="form-select select-active-block" 
                                id="statusSelect{{ $booking->id }}" 
                                aria-label="Default select example" data-current-status="{{$booking->status}}"  {{ $booking->refund_amount ? 'disabled' : '' }}>
                                    <option value="pending" class="pending-op" {{ $booking->status == 'pending' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">pending</option>
                                    <option value="cancelled" class="cancel-op" {{ $booking->status == 'cancelled' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">Cancelled</option>
                                    <option value="confirmed" class="confirmed-op" {{ $booking->status == 'confirmed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">confirmed</option>
                                    <option value="completed" class="completed-op"  {{ $booking->status == 'completed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">completed</option>
                                </select>
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{ route('admin.view.booking.detail', [$booking->id]) }}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="{{ route('admin.edit.booking.detail', $booking->id) }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="statusChangeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="statusChangeModalText">Are you sure you want to change the booking status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="statusChangeForm" method="POST" action="">
                            @csrf
                            <input type="hidden" name="status" id="newStatusValue">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
   $(document).ready(function () {
    $('#vendorSelect').select2({ allowClear: true });

    $('#vendorSelect').on('change', function () {
        const url = new URL(window.location.href);
        const vendorId = $(this).val();

        if (vendorId) {
            url.searchParams.set('vendor_id', vendorId);
        } else {
            url.searchParams.delete('vendor_id');
        }

        window.location.href = url.toString();
    });
});
</script>
<script>
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";

    function exportData(type) {
        const timeFilter = $('#timeFilterForm select').val();
        const statusFilter = "{{ request('status', 'all') }}";
        const vendorFilter =  "{{ request('vendor_id')  }}";
        
        $('#exportTimeFilter').val(timeFilter);
        $('#exportStatusFilter').val(statusFilter);
        $('#exportVendorFilter').val(vendorFilter);
        
        const action = type === 'csv' 
            ? "{{ route('admin.bookings.download.csv') }}" 
            : "{{ route('admin.bookings.download.pdf') }}";
        $('#exportForm').attr('action', action);
        
        $('#exportForm').submit();
    }
$(document).ready(function() {

    $('#bookingTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

    $('#booking_user').on('keyup', function () {
        $('#bookingTable').DataTable().search(this.value).draw();
    });


    // Time filter change
    $('.select-main-head').on('change', function() {
        $('#timeFilterForm').submit();
    });
    
    // Search bookings
    // $('#booking_user').on('keyup', function() {
    //     let searchQuery = $(this).val();
        
    //     $.ajax({
    //         url: "{{ route('admin.booking.user.search') }}",
    //         method: 'GET',
    //         data: {
    //             search: searchQuery,
    //             time_filter: "{{ request('time_filter', 'year') }}"
    //         },
    //         success: function(response) {
    //             $('#searchBookingUser').html(response.html);
    //         },
    //         error: function(xhr, status, error) {
    //             console.error("Error: " + error);
    //         }
    //     });
    // });
    
    // Status change handling
    $('.select-active-block').on('change', function() {
        const $select = $(this);
        const newStatus = $select.val();
        const bookingId = $select.attr('id').replace('statusSelect', '');
        const currentStatus = $select.find('option:selected').data('previous-value');
        
        if (newStatus === currentStatus) {
            return;
        }
    
        let message = '';
        switch(newStatus) {
            case 'pending':
                message = 'Are you sure you want to set this booking as Pending?';
                break;
            case 'cancelled':
                message = 'Are you sure you want to cancel this booking?';
                break;
            case 'confirmed':
                message = 'Are you sure you want to confirm this booking?';
                break;
            case 'completed':
                message = 'Are you sure you want to mark this booking as Completed?';
                break;
        }
    
        $('#statusChangeModalText').text(message);
        $('#newStatusValue').val(newStatus);
        $('#statusChangeForm').attr('action', baseUrl +'/admin/bookings/' + bookingId + '/status');
        
        $('#statusChangeModal').data('select', $select);
        $('#statusChangeModal').data('current-status', currentStatus);
        
        $('#statusChangeModal').modal('show');
    });
    
    $('#statusChangeForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const url = form.attr('action');
        const $select = $('#statusChangeModal').data('select');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                if(response.success) {
                    $select.find('option:selected').data('previous-value', $('#newStatusValue').val());
                    
                    $('#statusChangeModal').modal('hide'); 
                    Swal.fire({
                            icon: 'success',
                            title: 'Booking Status',
                            text: 'Booking status updated successfully!',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.reload();
                            }
                        });
                    
                    updateRowStatus($select.closest('tr'), $('#newStatusValue').val());
                }
            },
            error: function(xhr) {
                console.error('Error:', xhr.responseText);
                alert('Error updating booking status. Please try again.');
                
                $select.val($('#statusChangeModal').data('current-status'));
                
                $('#statusChangeModal').modal('hide');
            }
        });
    });
    
    $('#statusChangeModal').on('hidden.bs.modal', function() {
        const $select = $(this).data('select');
        const currentStatus = $(this).data('current-status');
        
        if ($select && currentStatus) {
            $select.val(currentStatus);
        }
    });
    
    function updateRowStatus($row, status) {
        $row.removeClass('table-warning table-success table-danger table-info');
        
        switch(status) {
            case 'pending':
                $row.addClass('table-warning');
                break;
            case 'confirmed':
                $row.addClass('table-info');
                break;
            case 'completed':
                $row.addClass('table-success');
                break;
            case 'cancel':
                $row.addClass('table-danger');
                break;
        }
    }
  
});
</script>
@endsection